<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 14:44
 */
interface NewdbbackupDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Newdbbackup 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param newdbbackup primary key
 	 */
	public function delete($backupid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Newdbbackup newdbbackup
 	 */
	public function insert($newdbbackup);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Newdbbackup newdbbackup
 	 */
	public function update($newdbbackup);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBackupname($value);


	public function deleteByBackupname($value);


}
?>